/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;

public class ObtainPotionAction
extends AbstractGameAction {
    private AbstractPotion potion;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("AbstractPotion");
    public static final String[] TEXT = ObtainPotionAction.uiStrings.TEXT;

    public ObtainPotionAction(AbstractPotion potion) {
        this.actionType = AbstractGameAction.ActionType.SPECIAL;
        this.duration = Settings.ACTION_DUR_XFAST;
        this.potion = potion;
    }

    @Override
    public void update() {
        if (this.duration == Settings.ACTION_DUR_XFAST) {
            if (AbstractDungeon.player.potionCount() == 3) {
                AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, TEXT[0], true));
            } else {
                for (int i = 0; i < 3; ++i) {
                    if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
                    CardCrawlGame.sound.play("POTION_1");
                    this.potion.moveInstantly(AbstractDungeon.player.potions[i].currentX, AbstractDungeon.player.potions[i].currentY);
                    this.potion.isObtained = true;
                    this.potion.isDone = true;
                    this.potion.isAnimating = false;
                    this.potion.flash();
                    AbstractDungeon.player.potions[i] = this.potion;
                    break;
                }
            }
        }
        this.tickDuration();
    }
}

